<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
  <xsl:param name="xslConvertToCY" select="cif:xslConvertToCY"/>
  <!-- Unique cross section surfaces -->
  <xsl:variable name="uniqueSurfaceName" select="//CrossSectionSurfaces/CrossSectionSurface[not (@name = preceding::CrossSectionSurface/@name)]/@name"/>
  <!-- Cross Section Gradebook Report -->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Výpis příčných řezů</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <!-- Report Title -->
                <h2 lang="en">Výpis příčných řezů</h2>
                <p lang="en">
                  Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>
              <!-- Cross Section Set Data -->
              <xsl:for-each select="CrossSectionSet">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Název sady:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@setName"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Název trasy:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@alignmentName"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní grid:&#xa0; </th>
                      <td align="left" style="font-size: 80%">
                        <xsl:value-of select="../@inputGridScaleFactor" />
                      </td>
                      <td align="right" lang="en" style="font-size: 80%">
                        <strong>Poznámka:&#xa0; </strong>Všechny jendotky výpisu jsou
                        <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                        <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                        pokud není specifikováno jinak.
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr/>
                <!-- Cross Section Point Data -->
                <table width="100%">
                  <xsl:for-each select="$uniqueSurfaceName[../@type = 1]">
                    <tr>
                      <th align="left" lang="en">Povrch:&#xa0; </th>
                      <td align="left" colspan="5">
                        <xsl:value-of select="."/>
                      </td>
                    </tr>
                    <xsl:for-each select="//CrossSectionSurface[@name = current()]">
                      <xsl:for-each select="CrossSectionPoints">
                        <tr>
                          <th align="left" lang="en">Staničení:</th>
                          <td align="left" colspan="5" nowrap="nowrap">
                            <xsl:value-of select="cif:stationFormat(number(../../../Station/@externalStation), string(../../../Station/@externalStationName))"/>
                          </td>
                        </tr>
                        <xsl:call-template name="showPointData">
                          <xsl:with-param name="listNegative" select="CrossSectionPoint[@offset &lt; 0]"/>
                          <xsl:with-param name="listPositive" select="CrossSectionPoint[@offset &gt; 0]"/>
                          <xsl:with-param name="listZero" select="CrossSectionPoint[@offset = 0]"/>
                        </xsl:call-template>
                        <tr>
                          <td>&#xa0;</td>
                        </tr>
                      </xsl:for-each>
                    </xsl:for-each>
                  </xsl:for-each>
                </table>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="showPointData">
    <xsl:param name="listNegative"/>
    <xsl:param name="listPositive"/>
    <xsl:param name="listZero"/>
    <xsl:param name="restNegative" select="$listNegative[position() &lt; last() - 3]"/>
    <xsl:param name="restPositive" select="$listPositive[position() &gt; 4]"/>
    <tr>
      <th align="left" lang="en">Výška:</th>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last() - 3]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listNegative[position() = last() - 3]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last() - 2]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listNegative[position() = last() - 2]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last() - 1]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listNegative[position() = last() - 1]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last()]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listNegative[position() = last()]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listZero">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listZero/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 1]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listPositive[position() = 1]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 2]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listPositive[position() = 2]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 3]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listPositive[position() = 3]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 4]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:ordinateFormat(number($listPositive[position() = 4]/@elevation))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
    <tr>
      <th align="left" lang="en">Odstup:</th>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last() - 3]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listNegative[position() = last() - 3]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last() - 2]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listNegative[position() = last() - 2]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last() - 1]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listNegative[position() = last() - 1]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listNegative[position() = last()]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listNegative[position() = last()]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listZero">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listZero/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 1]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listPositive[position() = 1]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 2]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listPositive[position() = 2]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 3]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listPositive[position() = 3]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$listPositive[position() = 4]">
          <td align="right" style="padding-left:5px;padding-right:5px" nowrap="nowrap">
            <xsl:value-of select="cif:distanceFormat(number($listPositive[position() = 4]/@offset))"/>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <td>&#xa0;</td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
    <xsl:if test="$restNegative or $restPositive">
      <xsl:call-template name="showPointData">
        <xsl:with-param name="listNegative" select="$restNegative"/>
        <xsl:with-param name="listPositive" select="$restPositive"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Musíte vytvořit příčné řezy podél trasy a sada příčných řezů musí
        obsahovat povrchy a prvky, nad kterými chcete provádět výpis.
      </p>
      <p class="normal1" lang="en">
        Soubor dat XML můžete vytvořit příkazem Kubatura z příčných řezů v 
          Vyhodnocení &gt; Příčné řezy &gt; Příčné řezy se zapnutým parametrem
          Vytvořit XML výpis  v záložce Obecně nebo příkazem Vyhodnocení &gt;
          Příčné řezy &gt; Výpis příčných řezů se zapnutým parametrem Včetně objemu v záložce Hlavní.
      </p>
      <p class="normal1" lang="en">
        Tento výpis pracuje jen s povrchy typu <em>Návrh</em>.
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2006 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
